---@meta

---@class FAudioMeterStyle : FSlateWidgetStyle
---@field MeterValueImage FSlateBrush
---@field BackgroundImage FSlateBrush
---@field MeterBackgroundImage FSlateBrush
---@field MeterValueBackgroundImage FSlateBrush
---@field MeterPeakImage FSlateBrush
---@field MeterSize FVector2D
---@field MeterPadding FVector2D
---@field MeterValuePadding float
---@field PeakValueWidth float
---@field ValueRangeDb FVector2D
---@field bShowScale boolean
---@field bScaleSide boolean
---@field ScaleHashOffset float
---@field ScaleHashWidth float
---@field ScaleHashHeight float
---@field DecibelsPerHash int32
---@field Font FSlateFontInfo
local FAudioMeterStyle = {}



---@class FAudioOscilloscopePanelStyle : FSlateWidgetStyle
---@field TimeRulerStyle FFixedSampleSequenceRulerStyle
---@field ValueGridStyle FSampledSequenceValueGridOverlayStyle
---@field WaveViewerStyle FSampledSequenceViewerStyle
---@field TriggerThresholdLineStyle FTriggerThresholdLineStyle
local FAudioOscilloscopePanelStyle = {}



---@class FAudioRadialSliderStyle : FSlateWidgetStyle
---@field TextBoxStyle FAudioTextBoxStyle
---@field CenterBackgroundColor FSlateColor
---@field SliderBarColor FSlateColor
---@field SliderProgressColor FSlateColor
---@field LabelPadding float
---@field DefaultSliderRadius float
local FAudioRadialSliderStyle = {}



---@class FAudioSliderStyle : FSlateWidgetStyle
---@field SliderStyle FSliderStyle
---@field TextBoxStyle FAudioTextBoxStyle
---@field WidgetBackgroundImage FSlateBrush
---@field SliderBackgroundColor FSlateColor
---@field SliderBackgroundSize FVector2D
---@field LabelPadding float
---@field SliderBarColor FSlateColor
---@field SliderThumbColor FSlateColor
---@field WidgetBackgroundColor FSlateColor
local FAudioSliderStyle = {}



---@class FAudioSpectrumPlotStyle : FSlateWidgetStyle
---@field BackgroundColor FSlateColor
---@field GridColor FSlateColor
---@field AxisLabelColor FSlateColor
---@field AxisLabelFont FSlateFontInfo
---@field SpectrumColor FSlateColor
local FAudioSpectrumPlotStyle = {}



---@class FAudioTextBoxStyle : FSlateWidgetStyle
---@field BackgroundImage FSlateBrush
---@field BackgroundColor FSlateColor
local FAudioTextBoxStyle = {}



---@class FAudioVectorscopePanelStyle : FSlateWidgetStyle
---@field ValueGridStyle FSampledSequenceValueGridOverlayStyle
---@field VectorViewerStyle FSampledSequenceVectorViewerStyle
local FAudioVectorscopePanelStyle = {}



---@class FFixedSampleSequenceRulerStyle : FSlateWidgetStyle
---@field HandleWidth float
---@field HandleColor FSlateColor
---@field HandleBrush FSlateBrush
---@field TicksColor FSlateColor
---@field TicksTextColor FSlateColor
---@field TicksTextFont FSlateFontInfo
---@field TicksTextOffset float
---@field BackgroundColor FSlateColor
---@field BackgroundBrush FSlateBrush
---@field DesiredWidth float
---@field DesiredHeight float
local FFixedSampleSequenceRulerStyle = {}



---@class FMeterChannelInfo
---@field MeterValue float
---@field PeakValue float
---@field ClippingValue float
local FMeterChannelInfo = {}



---@class FPlayheadOverlayStyle : FSlateWidgetStyle
---@field PlayheadColor FSlateColor
---@field PlayheadWidth float
---@field DesiredWidth float
---@field DesiredHeight float
local FPlayheadOverlayStyle = {}



---@class FSampledSequenceValueGridOverlayStyle : FSlateWidgetStyle
---@field GridColor FSlateColor
---@field GridThickness float
---@field LabelTextColor FSlateColor
---@field LabelTextFont FSlateFontInfo
---@field DesiredWidth float
---@field DesiredHeight float
local FSampledSequenceValueGridOverlayStyle = {}



---@class FSampledSequenceVectorViewerStyle : FSlateWidgetStyle
---@field BackgroundColor FSlateColor
---@field BackgroundBrush FSlateBrush
---@field LineColor FLinearColor
---@field LineThickness float
local FSampledSequenceVectorViewerStyle = {}



---@class FSampledSequenceViewerStyle : FSlateWidgetStyle
---@field SequenceColor FSlateColor
---@field SequenceLineThickness float
---@field MajorGridLineColor FSlateColor
---@field MinorGridLineColor FSlateColor
---@field ZeroCrossingLineColor FSlateColor
---@field ZeroCrossingLineThickness float
---@field SampleMarkersSize float
---@field SequenceBackgroundColor FSlateColor
---@field BackgroundBrush FSlateBrush
---@field DesiredWidth float
---@field DesiredHeight float
local FSampledSequenceViewerStyle = {}



---@class FTriggerThresholdLineStyle : FSlateWidgetStyle
---@field LineColor FLinearColor
local FTriggerThresholdLineStyle = {}



---@class UAudioFrequencyRadialSlider : UAudioRadialSlider
local UAudioFrequencyRadialSlider = {}


---@class UAudioFrequencySlider : UAudioSliderBase
---@field OutputRange FVector2D
local UAudioFrequencySlider = {}



---@class UAudioMeter : UWidget
---@field MeterChannelInfo TArray<FMeterChannelInfo>
---@field MeterChannelInfoDelegate FAudioMeterMeterChannelInfoDelegate
---@field WidgetStyle FAudioMeterStyle
---@field orientation EOrientation
---@field BackgroundColor FLinearColor
---@field MeterBackgroundColor FLinearColor
---@field MeterValueColor FLinearColor
---@field MeterPeakColor FLinearColor
---@field MeterClippingColor FLinearColor
---@field MeterScaleColor FLinearColor
---@field MeterScaleLabelColor FLinearColor
local UAudioMeter = {}

---@param InValue FLinearColor
function UAudioMeter:SetMeterValueColor(InValue) end
---@param InValue FLinearColor
function UAudioMeter:SetMeterScaleLabelColor(InValue) end
---@param InValue FLinearColor
function UAudioMeter:SetMeterScaleColor(InValue) end
---@param InValue FLinearColor
function UAudioMeter:SetMeterPeakColor(InValue) end
---@param InValue FLinearColor
function UAudioMeter:SetMeterClippingColor(InValue) end
---@param InMeterChannelInfo TArray<FMeterChannelInfo>
function UAudioMeter:SetMeterChannelInfo(InMeterChannelInfo) end
---@param InValue FLinearColor
function UAudioMeter:SetMeterBackgroundColor(InValue) end
---@param InValue FLinearColor
function UAudioMeter:SetBackgroundColor(InValue) end
---@return TArray<FMeterChannelInfo>
function UAudioMeter:GetMeterChannelInfo__DelegateSignature() end
---@return TArray<FMeterChannelInfo>
function UAudioMeter:GetMeterChannelInfo() end


---@class UAudioOscilloscope : UWidget
---@field OscilloscopeStyle FAudioOscilloscopePanelStyle
---@field AudioBus UAudioBus
---@field TimeWindowMs float
---@field AnalysisPeriodMs float
---@field bShowTimeGrid boolean
---@field TimeGridLabelsUnit EXAxisLabelsUnit
---@field bShowAmplitudeGrid boolean
---@field bShowAmplitudeLabels boolean
---@field AmplitudeGridLabelsUnit EYAxisLabelsUnit
---@field bShowTriggerThresholdLine boolean
---@field TriggerThreshold float
---@field PanelLayoutType EAudioPanelLayoutType
local UAudioOscilloscope = {}

function UAudioOscilloscope:StopProcessing() end
function UAudioOscilloscope:StartProcessing() end
---@return TArray<float>
function UAudioOscilloscope:GetOscilloscopeAudioSamples__DelegateSignature() end


---@class UAudioRadialSlider : UWidget
---@field Value float
---@field ValueDelegate FAudioRadialSliderValueDelegate
---@field WidgetLayout EAudioRadialSliderLayout
---@field CenterBackgroundColor FLinearColor
---@field SliderProgressColor FLinearColor
---@field SliderBarColor FLinearColor
---@field HandStartEndRatio FVector2D
---@field UnitsText FText
---@field TextLabelBackgroundColor FLinearColor
---@field ShowLabelOnlyOnHover boolean
---@field ShowUnitsText boolean
---@field IsUnitsTextReadOnly boolean
---@field IsValueTextReadOnly boolean
---@field SliderThickness float
---@field OutputRange FVector2D
---@field OnValueChanged FAudioRadialSliderOnValueChanged
local UAudioRadialSlider = {}

---@param InLayout EAudioRadialSliderLayout
function UAudioRadialSlider:SetWidgetLayout(InLayout) end
---@param bIsReadOnly boolean
function UAudioRadialSlider:SetValueTextReadOnly(bIsReadOnly) end
---@param bIsReadOnly boolean
function UAudioRadialSlider:SetUnitsTextReadOnly(bIsReadOnly) end
---@param Units FText
function UAudioRadialSlider:SetUnitsText(Units) end
---@param InColor FSlateColor
function UAudioRadialSlider:SetTextLabelBackgroundColor(InColor) end
---@param InThickness float
function UAudioRadialSlider:SetSliderThickness(InThickness) end
---@param InValue FLinearColor
function UAudioRadialSlider:SetSliderProgressColor(InValue) end
---@param InValue FLinearColor
function UAudioRadialSlider:SetSliderBarColor(InValue) end
---@param bShowUnitsText boolean
function UAudioRadialSlider:SetShowUnitsText(bShowUnitsText) end
---@param bShowLabelOnlyOnHover boolean
function UAudioRadialSlider:SetShowLabelOnlyOnHover(bShowLabelOnlyOnHover) end
---@param InOutputRange FVector2D
function UAudioRadialSlider:SetOutputRange(InOutputRange) end
---@param InHandStartEndRatio FVector2D
function UAudioRadialSlider:SetHandStartEndRatio(InHandStartEndRatio) end
---@param InValue FLinearColor
function UAudioRadialSlider:SetCenterBackgroundColor(InValue) end
---@param OutputValue float
---@return float
function UAudioRadialSlider:GetSliderValue(OutputValue) end
---@param InSliderValue float
---@return float
function UAudioRadialSlider:GetOutputValue(InSliderValue) end


---@class UAudioSlider : UAudioSliderBase
---@field LinToOutputCurve TWeakObjectPtr<UCurveFloat>
---@field OutputToLinCurve TWeakObjectPtr<UCurveFloat>
local UAudioSlider = {}



---@class UAudioSliderBase : UWidget
---@field Value float
---@field UnitsText FText
---@field TextLabelBackgroundColor FLinearColor
---@field TextLabelBackgroundColorDelegate FAudioSliderBaseTextLabelBackgroundColorDelegate
---@field ShowLabelOnlyOnHover boolean
---@field ShowUnitsText boolean
---@field IsUnitsTextReadOnly boolean
---@field IsValueTextReadOnly boolean
---@field ValueDelegate FAudioSliderBaseValueDelegate
---@field SliderBackgroundColor FLinearColor
---@field SliderBackgroundColorDelegate FAudioSliderBaseSliderBackgroundColorDelegate
---@field SliderBarColor FLinearColor
---@field SliderBarColorDelegate FAudioSliderBaseSliderBarColorDelegate
---@field SliderThumbColor FLinearColor
---@field SliderThumbColorDelegate FAudioSliderBaseSliderThumbColorDelegate
---@field WidgetBackgroundColor FLinearColor
---@field WidgetBackgroundColorDelegate FAudioSliderBaseWidgetBackgroundColorDelegate
---@field orientation EOrientation
---@field OnValueChanged FAudioSliderBaseOnValueChanged
local UAudioSliderBase = {}

---@param InValue FLinearColor
function UAudioSliderBase:SetWidgetBackgroundColor(InValue) end
---@param bIsReadOnly boolean
function UAudioSliderBase:SetValueTextReadOnly(bIsReadOnly) end
---@param bIsReadOnly boolean
function UAudioSliderBase:SetUnitsTextReadOnly(bIsReadOnly) end
---@param Units FText
function UAudioSliderBase:SetUnitsText(Units) end
---@param InColor FSlateColor
function UAudioSliderBase:SetTextLabelBackgroundColor(InColor) end
---@param InValue FLinearColor
function UAudioSliderBase:SetSliderThumbColor(InValue) end
---@param InValue FLinearColor
function UAudioSliderBase:SetSliderBarColor(InValue) end
---@param InValue FLinearColor
function UAudioSliderBase:SetSliderBackgroundColor(InValue) end
---@param bShowUnitsText boolean
function UAudioSliderBase:SetShowUnitsText(bShowUnitsText) end
---@param bShowLabelOnlyOnHover boolean
function UAudioSliderBase:SetShowLabelOnlyOnHover(bShowLabelOnlyOnHover) end
---@param OutputValue float
---@return float
function UAudioSliderBase:GetSliderValue(OutputValue) end
---@param InSliderValue float
---@return float
function UAudioSliderBase:GetOutputValue(InSliderValue) end
---@param OutputValue float
---@return float
function UAudioSliderBase:GetLinValue(OutputValue) end


---@class UAudioVectorscope : UWidget
---@field VectorscopeStyle FAudioVectorscopePanelStyle
---@field AudioBus UAudioBus
---@field bShowGrid boolean
---@field GridDivisions int32
---@field DisplayPersistenceMs float
---@field Scale float
---@field PanelLayoutType EAudioPanelLayoutType
local UAudioVectorscope = {}

function UAudioVectorscope:StopProcessing() end
function UAudioVectorscope:StartProcessing() end
---@return TArray<float>
function UAudioVectorscope:GetVectorscopeAudioSamples__DelegateSignature() end


---@class UAudioVolumeRadialSlider : UAudioRadialSlider
local UAudioVolumeRadialSlider = {}


---@class UAudioVolumeSlider : UAudioSlider
local UAudioVolumeSlider = {}


